/*
**  pmsimple.c (10/27/95)
**
**  Protected Mode SIMPLE
*/

#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <dos.h>
#include <string.h>
#include <conio.h>

#include "pcl4c.h"
#include "use_dpmi.h"

/*** Global Variables ***/

int Port = COM1;          /* Port COM1 */
int BaudCode;             /* baud rate code ( index into BaudRate[] ) */
char *BaudRate[10] =  {"300","600","1200","2400","4800","9600",
                       "19200","38400","57600","115200"};

/*** local prototypes */

int BaudMatch(char *);
int ErrorCheck(int);

/*** main ***/

void main(int argc, char *argv[])
{char c;
 int  i, rc;
 long hRxMem;
 long hTxMem;
 int  RxSelector = 0;
 int  TxSelector = 0;
 long Version;
 if(argc!=3)
   {printf("Usage: PMSIMPLE <port> <baud>\n");
    exit(1);
   }
 /* get port number from command line */
 Port = atoi(argv[1]) - 1;
 if((Port<COM1) || (Port>COM20))
     {printf("Port must be COM1 to COM20n");
      exit(1);
     }
 /* get baud rate from command line */
 BaudCode = BaudMatch(argv[2]);
 if(BaudCode<0)
     {printf("Cannot recognize baud rate = %s\n",argv[2]);
      exit(1);
     }
 /* setup 128 byte receive buffer */
 hRxMem = (long) GlobalDosAlloc( 128L );
 if(hRxMem)
   {/* get selector */
    RxSelector = LOWORD(hRxMem);
    GlobalPageLock(RxSelector);
   }
 else
   {printf("GlobalDosAlloc failed\n");
    exit(1);
   }
 SioRxBuf(Port,RxSelector,Size128);
 printf("RX buffer allocated\n");
 /* transmitter interrupt enabled ? */
 if(SioInfo('I'))
   {/* setup 128 byte transmit buffer */
    hTxMem = (long) GlobalDosAlloc( 128L );
    if(hTxMem)
      {/* get selector */
       TxSelector = LOWORD(hTxMem);
       GlobalPageLock(TxSelector);
      }
    else
      {printf("GlobalDosAlloc failed\n");
       if(RxSelector)
         {GlobalPageUnlock(RxSelector);
          GlobalDosFree(RxSelector);
         }
       exit(1);
      }
    SioTxBuf(Port,TxSelector,Size128);
    printf("TX buffer allocated\n");
   }
 /* set port parmameters */
 ErrorCheck( SioParms(Port,NoParity,OneStopBit,WordLength8) );
 /* reset the port */
 ErrorCheck( SioReset(Port,BaudCode) );
 /* set DTR and RTS */
 ErrorCheck( SioDTR(Port,'S') );
 ErrorCheck( SioRTS(Port,'S') );
 #if 0
 /* set RTS/CTS flow control */
 ErrorCheck( SioFlow(Port,18) );
 puts("Flow control on");
#endif
 /* Set FIFO level */
 if(SioFIFO(Port,LEVEL_14)) printf("[16550]\n");
 /* get DPMI version # */
 Version = DPMI_GetVersion();
 if(HIWORD(Version)) printf("\n32-bit ");
 else printf("\n16-bit ");
 i = LOWORD(Version);
 printf("DPMI Version %d.%d\n", (i>>8),i&255);
 printf("Enter terminal loop ( Type ^Z to exit )\n");

 /* enter terminal loop */
 while(TRUE)
     {if(SioBrkKey())
        {/* restore COM port status & exit */
         printf("BREAK\n");
         SioDone(Port);
         exit(2);
        }
      /* was key pressed ? */
      if(kbhit())
          {i = getch();
           if((char)i==0x1a)
              {/* restore COM port */
               SioDone(Port);
               /* free DOS memory */
               if(RxSelector)
                 {GlobalPageUnlock(RxSelector);
                  GlobalDosFree(RxSelector);
                 }
               if(TxSelector)
                 {GlobalPageUnlock(TxSelector);
                  GlobalDosFree(TxSelector);
                 }
               exit(1);
              }
           else
              {
               SioPutc(Port,(char)i);
               /*printf("(%d)",SioInfo('R') );*/
              }
          } /* end if */
      /* any incoming over serial port ? */
      i = SioGetc(Port,0);
      if(i>-1) putch((char)i);
      if(SioBrkSig(Port,'D')) printf("[BREAK detected]");

     } /* end while */
} /* end main */

int ErrorCheck(int Code)
{/* trap PCL error codes */
 if(Code<0)
     {printf("ERROR %d:",Code);
      SioError(Code);
      SioDone(Port);
      exit(1);
     }
 return(0);
} /* end ErrorCheck */


int BaudMatch(char *P)
{int i;
 /* find baud rate in table */
 for(i=0;i<10;i++) if(strcmp(BaudRate[i],P)==0) return(i);
 return(-1);
}
